package gov.va.vamf.scheduling.varutility.service;

import gov.va.vamf.scheduling.varutility.datalayer.DirectBookingEligibilityCriteriaRepository;
import gov.va.vamf.scheduling.varutility.domain.ClinicalServices;
import gov.va.vamf.scheduling.varutility.domain.CoreSettings;
import gov.va.vamf.scheduling.varutility.domain.DirectBookingEligibilityCriteria;
import gov.va.vamf.scheduling.varutility.linkbuilder.LinkBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.ws.rs.core.UriInfo;
import java.util.List;

@Service
public class DirectBookingEligibilityCriteriaService {

    @Autowired
    private DirectBookingEligibilityCriteriaRepository directBookingEligibilityCriteriaRepository;

    @Autowired
    private CoreSettingsService coreSettingsService;


    public DirectBookingEligibilityCriteria fetchPatientHistoryOptions(String siteCode, List<ClinicalServices> clinicalServices, UriInfo uriInfo) {
        DirectBookingEligibilityCriteria criteria = directBookingEligibilityCriteriaRepository.findById(siteCode);
        if(criteria == null) {
            criteria = new DirectBookingEligibilityCriteria();
            criteria.setId(siteCode);
            criteria.setCoreSettings(coreSettingsService.createDefaultCoreSettings(clinicalServices));
        } else {
            CoreSettings coreSettings = criteria.getCoreSettings();
            criteria.setCoreSettings(coreSettingsService.updateCriteriaCoreSettings(coreSettings, clinicalServices));
            LinkBuilder.fillLink(criteria, uriInfo.getRequestUri());
        }
        return criteria;
    }

    public DirectBookingEligibilityCriteria savePatientHistoryOptions(DirectBookingEligibilityCriteria criteria) {
        return directBookingEligibilityCriteriaRepository.save(criteria);
    }

    public DirectBookingEligibilityCriteria updatePatientHistoryOptions(DirectBookingEligibilityCriteria criteria) {
        return directBookingEligibilityCriteriaRepository.save(criteria);
    }
}
